/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.managers;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStackHolder;
import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IFuelManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.BaseDynamoFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class SingleFluidFuelManager
extends AbstractManager
implements IFuelManager {
    public static final int MIN_ENERGY = 10000;
    public static final int MAX_ENERGY = 200000000;
    public static final int FLUID_FUEL_AMOUNT = 100;
    public static final int ENERGY_FACTOR = 10;
    protected Map<Integer, IDynamoFuel> fuelMap = new Object2ObjectOpenHashMap();

    protected SingleFluidFuelManager(int defaultEnergy) {
        super(defaultEnergy);
        this.basePower = 40;
    }

    public void addFuel(ThermalFuel recipe) {
        for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
            this.addFuel(recipe.getEnergy(), Collections.emptyList(), Collections.singletonList(fluidInput));
        }
    }

    public boolean validFuel(FluidStack input) {
        return this.getFuel(input) != null;
    }

    protected void clear() {
        this.fuelMap.clear();
    }

    protected IDynamoFuel getFuel(FluidStack input) {
        return this.getFuel(Collections.emptyList(), Collections.singletonList(new FluidStackHolder(input)));
    }

    protected IDynamoFuel getFuel(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        return this.fuelMap.get(FluidHelper.fluidHashcode((FluidStack)inputTanks.get(0).getFluidStack()));
    }

    public IDynamoFuel addFuel(int energy, List<ItemStack> inputItems, List<FluidStack> inputFluids) {
        if (inputFluids.isEmpty() || energy <= 0) {
            return null;
        }
        if (energy < 10000 || energy > 200000000) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        int amount = input.getAmount();
        if (amount != 100) {
            if (amount != 1000) {
                long normEnergy = energy * 1000 / amount;
                input.setAmount(100);
                energy = (int)normEnergy;
            }
            energy /= 10;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        BaseDynamoFuel fuel = new BaseDynamoFuel(energy, inputItems, inputFluids);
        this.fuelMap.put(FluidHelper.fluidHashcode((FluidStack)input), fuel);
        return fuel;
    }

    @Override
    public int getMinPower() {
        return 10;
    }

    @Override
    public IDynamoFuel getFuel(IThermalInventory inventory) {
        return this.getFuel(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IDynamoFuel> getFuelList() {
        return new ArrayList<IDynamoFuel>(this.fuelMap.values());
    }
}

